package com.ejie.aa17a.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aRegistroMaestroDao;
import com.ejie.aa17a.model.Aa17aRegistroMaestro;
import com.ejie.aa17a.service.iface.Aa17aRegistroMaestroService;
import com.ejie.x38.dto.Pagination;

/**
 * Aa17aRegistroMaestroServiceImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

public class Aa17aRegistroMaestroServiceImpl implements Aa17aRegistroMaestroService {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aRegistroMaestroServiceImpl.class);

	private Aa17aRegistroMaestroDao aa17aRegistroMaestroDao;

	/**
	 * Inserts a single row in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @return Aa17aRegistroMaestro
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa17aRegistroMaestro add(Aa17aRegistroMaestro aa17aRegistroMaestro) {
		return this.aa17aRegistroMaestroDao.add(aa17aRegistroMaestro);
	}

	/**
	 * Updates a single row in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @return Aa17aRegistroMaestro
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa17aRegistroMaestro update(Aa17aRegistroMaestro aa17aRegistroMaestro) {
		return this.aa17aRegistroMaestroDao.update(aa17aRegistroMaestro);
	}

	/**
	 * Finds a single row in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @return Aa17aRegistroMaestro
	 */
	public Aa17aRegistroMaestro find(Aa17aRegistroMaestro aa17aRegistroMaestro) {
		return (Aa17aRegistroMaestro) this.aa17aRegistroMaestroDao.find(aa17aRegistroMaestro);
	}

	/**
	 * Finds a List of rows in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Aa17aRegistroMaestro> findAll(Aa17aRegistroMaestro aa17aRegistroMaestro, Pagination pagination) {
		return (List<Aa17aRegistroMaestro>) this.aa17aRegistroMaestroDao.findAll(aa17aRegistroMaestro, pagination);
	}

	/**
	 * Counts rows in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @return Long
	 */
	public Long findAllCount(Aa17aRegistroMaestro aa17aRegistroMaestro) {
		return this.aa17aRegistroMaestroDao.findAllCount(aa17aRegistroMaestro);
	}

	/**
	 * Finds rows in the Aa17aRegistroMaestro table using like.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Aa17aRegistroMaestro> findAllLike(Aa17aRegistroMaestro aa17aRegistroMaestro, Pagination pagination, Boolean startsWith) {
		return (List<Aa17aRegistroMaestro>) this.aa17aRegistroMaestroDao.findAllLike(aa17aRegistroMaestro, pagination, startsWith);
	}

	/**
	 * Counts rows in the Aa17aRegistroMaestro table using like.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Aa17aRegistroMaestro aa17aRegistroMaestro, Boolean startsWith) {
		return this.aa17aRegistroMaestroDao.findAllLikeCount(aa17aRegistroMaestro, startsWith);
	}

	/**
	 * Deletes a single row in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa17aRegistroMaestro aa17aRegistroMaestro) {
		this.aa17aRegistroMaestroDao.remove(aa17aRegistroMaestro);
	}

	/**
	 * Deletes multiple rows in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aRegistroMaestroList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Aa17aRegistroMaestro> aa17aRegistroMaestroList) {
		for (Aa17aRegistroMaestro aa17aRegistroMaestroAux : aa17aRegistroMaestroList) {
			this.aa17aRegistroMaestroDao.remove(aa17aRegistroMaestroAux);
		}
	}

	/**
	 * Setter method for Aa17aRegistroMaestroDao.
	 * 
	 * @param aa17aRegistroMaestroDao
	 *            Aa17aRegistroMaestroDao
	 * @return
	 */
	public void setAa17aRegistroMaestroDao(Aa17aRegistroMaestroDao aa17aRegistroMaestroDao) {
		Aa17aRegistroMaestroServiceImpl.logger.info("Setting Dependency " + aa17aRegistroMaestroDao);
		this.aa17aRegistroMaestroDao = aa17aRegistroMaestroDao;
	}
}
